<?php 
/**
 * WP Graphql Page
 *
 * @author   Magazine3
 * @category Output
 * @path     output/rest-api/wpgraphql
 * @version 1.9.76
 */

if (!defined('ABSPATH')) {
    exit();
}

use WPGraphQL\AppContext;
add_action( 'graphql_register_types', 'saswp_register_schema_output' );

/**
 * Function to extends WP Graph Ql Schema to get generated schema markup for the post types
 * @global type $post 
 * @return array
 */    
function saswp_register_schema_output() {
        
    register_graphql_object_type( 'saswpSchemaType', [
        'description' => saswp_t_string( 'Data from Schema & Structured Data for WP & AMP'),
        'fields' => [
          'json_ld' => [
            'type' => 'String',
            'description' => saswp_t_string( 'Get the whole Json-ld generated by from Schema & Structured Data for WP & AMP' ),
          ]          
        ],
      ] );

      //Get schema data for post query
    $post_types = \WPGraphQL::get_allowed_post_types();

    if(!empty($post_types) && is_array($post_types)){
     
        foreach ($post_types as $post_type) {

                $post_type_object = get_post_type_object($post_type);

                if (isset($post_type_object->graphql_single_name)){
                 
                    register_graphql_field( $post_type_object->graphql_single_name, 'saswpSchema', [
                        
                        'type' => 'saswpSchemaType',
                        'resolve' => function($post, array $args, AppContext $context) {
                          
                            require_once SASWP_PLUGIN_DIR_PATH.'output/rest-api/api-service.php'; 
                            $restApiObj = new SASWP_Output_Rest_Api_Service();
                            $response = $restApiObj->get_schema($post->ID);
                            
                            return [ 'json_ld' => wp_json_encode($response, JSON_UNESCAPED_SLASHES )];

                          }
                       ] 
                    );                    
                }
           }
      }
}