<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\PeopleService;

class EmailAddress extends \Google\Site_Kit_Dependencies\Google\Model
{
    /**
     * The display name of the email.
     *
     * @var string
     */
    public $displayName;
    /**
     * Output only. The type of the email address translated and formatted in the
     * viewer's account locale or the `Accept-Language` HTTP header locale.
     *
     * @var string
     */
    public $formattedType;
    protected $metadataType = \Google\Site_Kit_Dependencies\Google\Service\PeopleService\FieldMetadata::class;
    protected $metadataDataType = '';
    /**
     * The type of the email address. The type can be custom or one of these
     * predefined values: * `home` * `work` * `other`
     *
     * @var string
     */
    public $type;
    /**
     * The email address.
     *
     * @var string
     */
    public $value;
    /**
     * The display name of the email.
     *
     * @param string $displayName
     */
    public function setDisplayName($displayName)
    {
        $this->displayName = $displayName;
    }
    /**
     * @return string
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Output only. The type of the email address translated and formatted in the
     * viewer's account locale or the `Accept-Language` HTTP header locale.
     *
     * @param string $formattedType
     */
    public function setFormattedType($formattedType)
    {
        $this->formattedType = $formattedType;
    }
    /**
     * @return string
     */
    public function getFormattedType()
    {
        return $this->formattedType;
    }
    /**
     * Metadata about the email address.
     *
     * @param FieldMetadata $metadata
     */
    public function setMetadata(\Google\Site_Kit_Dependencies\Google\Service\PeopleService\FieldMetadata $metadata)
    {
        $this->metadata = $metadata;
    }
    /**
     * @return FieldMetadata
     */
    public function getMetadata()
    {
        return $this->metadata;
    }
    /**
     * The type of the email address. The type can be custom or one of these
     * predefined values: * `home` * `work` * `other`
     *
     * @param string $type
     */
    public function setType($type)
    {
        $this->type = $type;
    }
    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * The email address.
     *
     * @param string $value
     */
    public function setValue($value)
    {
        $this->value = $value;
    }
    /**
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\PeopleService\EmailAddress::class, 'Google\\Site_Kit_Dependencies\\Google_Service_PeopleService_EmailAddress');
